#include <iostream>
#include <algorithm>

using namespace std;

struct Pomeraj{
    int x;
    int y;
    int i;
};

int vek_pr(Pomeraj a, Pomeraj b) {
    return a.x * b.y - b.x * a.y;
}

int skal_pr(Pomeraj a, Pomeraj b) {
    return a.x * b.x + a.y * b.y;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    cin >> n;
    
    Pomeraj pomeraji[n];
    for(int i = 0; i < n; i++) {
        cin >> pomeraji[i].x >> pomeraji[i].y;
        pomeraji[i].i = i;
    }
    
    sort(pomeraji, pomeraji + n, [](const Pomeraj &a, const Pomeraj &b) {
        bool A = a.y > 0 || (a.y == 0 && a.x >= 0);
        bool B = b.y > 0 || (b.y == 0 && b.x >= 0);
        if(A != B) return A;
        return vek_pr(a, b) > 0;
    });
    
    int maks_pocetak, maks_kraj;
    long long X = 0, Y = 0;
    unsigned long long maks_udaljenost = 0;
    for(int i = 0, j = 0; i < n;) {
        while(((vek_pr(pomeraji[i], pomeraji[j%n]) == 0 &&
                skal_pr(pomeraji[i], pomeraji[j%n]) > 0) ||
               vek_pr(pomeraji[i], pomeraji[j%n]) > 0) &&
              j - i < n) {
            X += pomeraji[j%n].x;
            Y += pomeraji[j%n].y;
            j++;
            if(maks_udaljenost < 1ull * X * X + Y * Y) {
                maks_udaljenost = 1ull * X * X + Y * Y;
                maks_pocetak = i;
                maks_kraj = j;
            }
        }
        
        int k = i;
        while(vek_pr(pomeraji[i], pomeraji[k%n]) == 0 &&
              skal_pr(pomeraji[i], pomeraji[k%n]) > 0 &&
              k - i < n) {
            X -= pomeraji[k%n].x;
            Y -= pomeraji[k%n].y;
            k++;
            if(maks_udaljenost < 1ull * X * X + Y * Y) {
                maks_udaljenost = 1ull * X * X + Y * Y;
                maks_pocetak = i;
                maks_kraj = j;
            }
        }
        while(vek_pr(pomeraji[i], pomeraji[j%n]) == 0 &&
              skal_pr(pomeraji[i], pomeraji[j%n]) < 0 &&
              j - k < n) {
            X += pomeraji[j%n].x;
            Y += pomeraji[j%n].y;
            j++;
            if(maks_udaljenost < 1ull * X * X + Y * Y) {
                maks_udaljenost = 1ull * X * X + Y * Y;
                maks_pocetak = k;
                maks_kraj = j;
            }
        }
        i = k;
    }
    
    int broj_pomeraja = maks_kraj - maks_pocetak;
    cout << broj_pomeraja << endl;
    for(int i = 0; i < broj_pomeraja; i++)
        cout << pomeraji[(maks_pocetak + i) % n].i + 1 << ' ';
    
    return 0;
}